import os
from PIL import Image

# Folder output untuk file .webp
output_folder = "webp"

# Buat folder jika belum ada
if not os.path.exists(output_folder):
    os.makedirs(output_folder)

# Ekstensi gambar yang akan di-convert
extensions = ('.jpg', '.jpeg', '.png', '.gif')

for file in os.listdir("."):
    if file.lower().endswith(extensions):
        try:
            img = Image.open(file)

            # Path output
            output_path = os.path.join(output_folder, os.path.splitext(file)[0] + ".webp")

            # Convert & save ke webp
            img.save(output_path, "webp")
            print(f"✔ Converted: {file} → {output_path}")

        except Exception as e:
            print(f"❌ Gagal convert {file}: {e}")

print("\n🎉 Selesai convert semua gambar ke .webp!")
